/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.service;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceFunction.class);

    public static <OutputType> OutputType serviceCallWrapper(Supplier<OutputType> function, String description) {
        long initialTime = System.currentTimeMillis();
        try {
            OutputType outputValue = function.get();
            long totalTimeSpent = System.currentTimeMillis() - initialTime;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Calling service successfully: %s, executionTime: %s ms", description, totalTimeSpent));
            }
            return outputValue;
        }
        catch (Exception e) {
            long totalTimeSpent = System.currentTimeMillis() - initialTime;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Calling service failure: %s, executionTime: %s ms", description, totalTimeSpent));
            }
            throw e;
        }
    }
}

