
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.glassfish.jersey.client.ClientProperties.READ_TIMEOUT;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException.newToolingServiceAPIException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;
import static org.slf4j.LoggerFactory.getLogger;

import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.cache.Cache;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.Components;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.dataWeave.DataWeave;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;

/**
 * Application web resource.
 *
 * @since 4.0
 */
public class ApplicationId {

  private final Logger logger = getLogger(this.getClass());

  private String baseUrl;
  private Client client;
  public final Components components;
  public final DataWeave dataweave;
  public Cache cache;

  public ApplicationId(String baseUrl, Client client, String uriParam) {
    this.baseUrl = (baseUrl + ("/" + uriParam));
    this.client = client;
    components = new Components(getBaseUri(), getClient());
    dataweave = new DataWeave(getBaseUri(), getClient());
    cache = new Cache(getBaseUri(), getClient());
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * DELETE operation, disposes this tooling application.
   *
   * @param verboseErrorsEnabled  flag that defines if it has to be verbose the response in case of errors/failures.
   * @param readTimeout           read timeout in milliseconds
   * @param verboseErrorsEnabled
   */
  public void delete(boolean verboseErrorsEnabled, int readTimeout) {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    if (readTimeout > 0) {
      invocationBuilder.property(READ_TIMEOUT, readTimeout);
    }
    invocationBuilder.async().delete(new InvocationCallback<Response>() {

      @Override
      public void completed(Response response) {
        if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
          logger.error("Could not dispose tooling application", newToolingServiceAPIException(response));
        }
      }

      @Override
      public void failed(Throwable throwable) {
        logger.error("Error while disposing tooling application", throwable);
      }
    });
  }

}
