/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static java.util.Optional.empty;
import static java.util.concurrent.TimeUnit.MILLISECONDS;
import static java.util.concurrent.TimeUnit.SECONDS;
import static org.awaitility.Awaitility.with;

import org.mule.tooling.client.test.AbstractMuleRuntimeTestCase;
import org.mule.tooling.client.test.RuntimeType;

import java.net.MalformedURLException;
import java.net.URL;

import org.awaitility.Duration;
import org.junit.Before;

public abstract class AbstractRestAgentToolingServiceTestCase extends AbstractMuleRuntimeTestCase {

  protected static final long AGENT_CONNECT_TIMEOUT_SECS = 15;
  protected static final long AGENT_READ_TIMEOUT_SECS = 60;

  protected RestAgentToolingService restAgentToolingService;

  protected String agentUrl = "http://localhost:" + agentPort.getNumber() + "/mule/tooling";

  public AbstractRestAgentToolingServiceTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Before
  public final void setupMuleAgentService() throws MalformedURLException {
    restAgentToolingService = createRestAgentToolingService(SECONDS.toMillis(AGENT_CONNECT_TIMEOUT_SECS),
                                                            SECONDS.toMillis(AGENT_READ_TIMEOUT_SECS));
  }

  protected RestAgentToolingService createRestAgentToolingService(long agentConnectTimeoutSecs, long agentReadTimeoutSecs)
      throws MalformedURLException {
    RestAgentToolingService restAgentToolingService = new RestAgentToolingService();
    restAgentToolingService.setToolingApiUrl(new URL(agentUrl), agentConnectTimeoutSecs, agentReadTimeoutSecs, empty(), empty());
    setMuleVersion(restAgentToolingService);

    with().timeout(new Duration(getStartUpTimeout(), SECONDS))
        .and().with().pollInterval(300, MILLISECONDS).and().with()
        .pollDelay(200, MILLISECONDS).await("Waiting for Agent Tooling Service to be operational")
        .until(() -> restAgentToolingService.isOperational());
    return restAgentToolingService;
  }

  protected void setMuleVersion(RestAgentToolingService restAgentToolingService) {
    restAgentToolingService.setMuleVersion(getMuleVersion());
  }

  protected long getStartUpTimeout() {
    return DEFAULT_START_TIMEOUT;
  }

}
