/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static java.util.Collections.emptyMap;
import static java.util.Collections.singletonList;
import static java.util.UUID.randomUUID;
import static org.apache.commons.lang3.tuple.ImmutablePair.of;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

import org.mule.tooling.client.test.RuntimeType;

import java.io.File;
import java.io.InputStream;
import java.util.List;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.apache.commons.lang3.tuple.ImmutablePair;

@Feature("Remote Runtime Tooling Service - Domain deployment endpoints without deployment properties")
@Story("DeployToolingArtifact")
public class DeployDomainWithUniqueIDTestCase extends DeployDomainTestCase {

  public DeployDomainWithUniqueIDTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Override
  protected void setMuleVersion(RestAgentToolingService restAgentToolingService) {
    restAgentToolingService.setMuleVersion(null);
  }

  @Override
  protected List<ImmutablePair<String, String>> getStartupSystemProperties() {
    return singletonList(of("emailServerPort", String.valueOf(emailServerPort.getNumber())));
  }

  @Override
  protected String doDeployDomain(File domainLocation) {
    String uniqueId = randomUUID().toString();
    String returnedId = restAgentToolingService.deployDomain(uniqueId, domainLocation, emptyMap());
    assertThat(returnedId, equalTo(uniqueId));
    return returnedId;
  }

  @Override
  protected String doDeployDomain(InputStream inputStream) {
    String uniqueId = randomUUID().toString();
    String returnedId = restAgentToolingService.deployDomain(uniqueId, inputStream, emptyMap());
    assertThat(returnedId, equalTo(uniqueId));
    return returnedId;
  }

}
