/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.valueProviders;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.glassfish.jersey.client.ClientProperties.READ_TIMEOUT;
import static org.mule.tooling.agent.rest.client.UriUtils.resolveUri;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException.newToolingAgentHandlerException;

import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.extension.api.persistence.value.ValueResultJsonSerializer;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

/**
 * Value Providers Resource
 *
 * @since 1.0
 */
public class ValueProviders {

  private final String baseUri;
  private final Client client;

  public ValueProviders(String baseUri, Client client) {
    this.baseUri = baseUri + "/valueProviders";
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUri;
  }

  /**
   * Returns the resolved {@link ValueResult} for a given value provider name.
   *
   * @param valueProviderName The name of the {@link ValueProvider} to execute
   * @param readTimeout       read timeout in milliseconds
   * @return The {@link ValueResult} indicating the result of the {@link Value} resolution
   */
  public ValueResult get(String valueProviderName, int readTimeout) throws ToolingAgentHandlerException {
    WebTarget target = this.getClient().target(resolveUri(getBaseUri(), valueProviderName));
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    if (readTimeout > 0) {
      invocationBuilder.property(READ_TIMEOUT, readTimeout);
    }
    Response response = invocationBuilder.get();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingAgentHandlerException(response);
    }

    return new ValueResultJsonSerializer().deserialize(response.readEntity(String.class));
  }
}
