/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client;

import static com.github.tomakehurst.wiremock.client.WireMock.aResponse;
import static com.github.tomakehurst.wiremock.client.WireMock.any;
import static com.github.tomakehurst.wiremock.client.WireMock.equalTo;
import static com.github.tomakehurst.wiremock.client.WireMock.getRequestedFor;
import static com.github.tomakehurst.wiremock.client.WireMock.putRequestedFor;
import static com.github.tomakehurst.wiremock.client.WireMock.urlPathMatching;
import static com.github.tomakehurst.wiremock.client.WireMock.verify;
import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;
import static java.util.Collections.emptyMap;
import static java.util.Optional.empty;
import static javax.ws.rs.core.HttpHeaders.AUTHORIZATION;

import com.github.tomakehurst.wiremock.junit.WireMockClassRule;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class AgentRestClientHeadersTestCase {

  private static final InputStream EMPTY_STREAM = new InputStream() {

    @Override
    public int read() throws IOException {
      return -1;
    }
  };

  @Rule
  public WireMockClassRule wireMockRule = new WireMockClassRule(wireMockConfig().dynamicPort());

  @Before
  public void setUp() {
    wireMockRule.stubFor(any(urlPathMatching("/.*"))
        .willReturn(aResponse()
            .withStatus(200)
            .withHeader("Content-Type", "application/json")
            .withBody("{}")));
  }

  @Test
  public void noAuthorizationHeaderIfNotSet() throws Exception {
    RestAgentToolingService service = createService(null);
    service.isOperational();
    service.deployDomain("domainId", EMPTY_STREAM, emptyMap());
    service.deployApplication("applicationId", EMPTY_STREAM, emptyMap());
    verify(getRequestedFor(urlPathMatching("/")).withoutHeader(AUTHORIZATION));
    verify(putRequestedFor(urlPathMatching("/domains?.*")).withoutHeader(AUTHORIZATION));
    verify(putRequestedFor(urlPathMatching("/applications?.*")).withoutHeader(AUTHORIZATION));
  }

  @Test
  public void authorizationHeaderIsUsedIfSet() throws Exception {
    final String token = "token";
    RestAgentToolingService service = createService(token);
    service.isOperational();
    service.deployDomain("domainId", EMPTY_STREAM, emptyMap());
    service.deployApplication("applicationId", EMPTY_STREAM, emptyMap());
    verify(getRequestedFor(urlPathMatching("/")).withHeader(AUTHORIZATION, equalTo(token)));
    verify(putRequestedFor(urlPathMatching("/domains?.*")).withHeader(AUTHORIZATION, equalTo(token)));
    verify(putRequestedFor(urlPathMatching("/applications?.*")).withHeader(AUTHORIZATION, equalTo(token)));
  }

  private RestAgentToolingService createService(String token) throws MalformedURLException {
    RestAgentToolingService restAgentToolingService = new RestAgentToolingService();
    restAgentToolingService.setToolingApiUrl(new URL("http://localhost:" + wireMockRule.port()),
                                             1000,
                                             1000,
                                             empty(),
                                             empty(),
                                             token);
    return restAgentToolingService;
  }

}
