/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static java.util.Collections.emptyMap;
import static java.util.UUID.randomUUID;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

import java.io.File;
import java.io.InputStream;
import java.util.function.Function;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature("Remote Runtime Tooling Service - Applications without deployment properties")
@Story("DeployToolingArtifact")
public class DeployApplicationWithUniqueIDTestCase extends DeployApplicationTestCase {

  @Override
  protected void setMuleVersion(RestAgentToolingService restAgentToolingService) {
    restAgentToolingService.setMuleVersion(null);
  }

  protected String doDeployDomain(File location) {
    return doDeployment(uniqueId -> restAgentToolingService.deployDomain(uniqueId, location, emptyMap()));
  }

  protected String doDeployDomain(InputStream inputStream) {
    return doDeployment(uniqueId -> restAgentToolingService.deployDomain(uniqueId, inputStream, emptyMap()));
  }

  protected String doDeployApplication(File emailAppLocation) {
    return doDeployment(uniqueId -> restAgentToolingService.deployApplication(uniqueId, emailAppLocation, emptyMap()));
  }

  protected String doDeployApplication(File location, String domainId) {
    return doDeployment(uniqueId -> restAgentToolingService.deployApplication(uniqueId, location, domainId, emptyMap()));
  }

  protected String doDeployApplication(InputStream inputStream) {
    return doDeployment(uniqueId -> restAgentToolingService.deployApplication(uniqueId, inputStream, emptyMap()));
  }

  protected String doDeployApplication(InputStream inputStream, String domainId) {
    return doDeployment(uniqueId -> restAgentToolingService.deployApplication(uniqueId, inputStream, domainId, emptyMap()));
  }

  private String doDeployment(Function<String, String> function) {
    String uniqueId = randomUUID().toString();
    String returnedId = function.apply(uniqueId);
    assertThat(returnedId, equalTo(uniqueId));
    return returnedId;
  }

}
