/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static java.util.Arrays.asList;
import static java.util.concurrent.TimeUnit.SECONDS;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;
import static org.junit.rules.ExpectedException.none;

import org.mule.tooling.client.test.junit4.annotations.RuntimeStartupArgs;
import org.mule.tooling.client.test.utils.probe.JUnitLambdaProbe;
import org.mule.tooling.client.test.utils.probe.PollingProber;

import java.io.File;
import java.util.List;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class DisposeOrphanDeployableTestCase extends AbstractDeploymentTestCase {

  @Rule
  public ExpectedException expectedException = none();

  @RuntimeStartupArgs
  private static List<String> provideStartupArgs() {
    return asList("-M-Dmule.agent.tooling.service.expireAfterAccessApplicationsThreshold=1",
                  "-M-Dmule.agent.tooling.service.expireAfterAccessApplicationsTimeUnit=SECONDS");
  }

  @Test
  public void testDisposeByEviction() throws Exception {
    File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
    File artifactLocation = new File(targetTestClassesFolder, getRelativeDeployablePath());

    String artifactId = doDeploy(artifactLocation);
    assertThat(artifactId, is(notNullValue()));

    new PollingProber(SECONDS.toMillis(3), 500)
        .check(new JUnitLambdaProbe(() -> new File(muleHome + "/.mule/tooling/apps").listFiles().length == 0));
  }

  protected abstract String getRelativeDeployablePath();

  protected abstract String doDeploy(File artifactPath);

}
