/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.function.Function;
import org.mule.runtime.api.connection.serialization.ErrorTypeSerializer;
import org.mule.runtime.api.message.ErrorType;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;

public class ConnectivityTestingResponseSerializer {
    private static final String VALIDATION_STATUS = "validationStatus";
    private static final String MESSAGE = "message";
    private static final String ERROR_TYPE = "errorType";
    private static final String REASON = "reason";
    private static final String EXCEPTION = "exception";
    private ErrorTypeSerializer errorTypeSerializer = ErrorTypeSerializer.create();

    public ConnectivityTestingResponse deserialize(String response) {
        JsonElement parse = new JsonParser().parse(response);
        JsonObject asJsonObject = parse.getAsJsonObject();
        if (!asJsonObject.has(VALIDATION_STATUS)) {
            throw new IllegalStateException("The deserialized ConnectivityTestingResponse doesn't provide a 'validationStatus'");
        }
        boolean validationStatus = asJsonObject.getAsJsonPrimitive(VALIDATION_STATUS).getAsBoolean();
        ErrorType errorType = this.doIfPresent(ERROR_TYPE, asJsonObject, object -> this.errorTypeSerializer.deserialize(object.getAsJsonObject(ERROR_TYPE).toString()));
        String reason = this.doIfPresent(REASON, asJsonObject, object -> object.getAsJsonPrimitive(REASON).getAsString());
        String message = this.doIfPresent(MESSAGE, asJsonObject, object -> object.getAsJsonPrimitive(MESSAGE).getAsString());
        String exception = this.doIfPresent(EXCEPTION, asJsonObject, object -> object.getAsJsonPrimitive(EXCEPTION).getAsString());
        return new ConnectivityTestingResponse(validationStatus, message, errorType, reason, exception);
    }

    private <T> T doIfPresent(String memberName, JsonObject jsonObject, Function<JsonObject, T> function) {
        return jsonObject.has(memberName) ? (T)function.apply(jsonObject) : null;
    }
}

