/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.domains;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.domains.domainId.DomainId;
import org.mule.tooling.agent.rest.client.tooling.domains.model.DomainsGETResponse;
import org.mule.tooling.agent.rest.client.tooling.domains.model.DomainsPUTBody;
import org.mule.tooling.agent.rest.client.tooling.domains.model.DomainsPUTResponse;

public class Domains {
    private static final String ARTIFACT_ID = "artifactId";
    private String baseUrl;
    private Client client;

    public Domains(String baseUrl, Client client) {
        this.baseUrl = baseUrl + "/domains";
        this.client = client;
    }

    private Client getClient() {
        return this.client;
    }

    private String getBaseUri() {
        return this.baseUrl;
    }

    public List<DomainsGETResponse> get(boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return (List)response.readEntity((GenericType)new GenericType<List<DomainsGETResponse>>(){});
    }

    public DomainsPUTResponse put(DomainsPUTBody body, boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.put(Entity.json((Object)body))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return (DomainsPUTResponse)response.readEntity(DomainsPUTResponse.class);
    }

    public DomainsPUTResponse put(InputStream body, String artifactId, boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        target = target.queryParam(ARTIFACT_ID, new Object[]{artifactId});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.put(Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return (DomainsPUTResponse)response.readEntity(DomainsPUTResponse.class);
    }

    public final DomainId domainId(String domainId) {
        return new DomainId(this.getBaseUri(), this.getClient(), domainId);
    }
}

