/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.sampledata;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.glassfish.jersey.client.ClientProperties.READ_TIMEOUT;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException.newToolingAgentHandlerException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;
import static org.mule.tooling.api.serialization.SerializerFactory.jsonSerializer;

import org.mule.tooling.api.sampledata.SampleDataMessageModelResult;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class SampleData {

  private String baseUrl;
  private Client client;

  public SampleData(String baseUrl, Client client) {
    this.baseUrl = baseUrl + "/sampledata";
    this.client = client;
  }

  public SampleDataMessageModelResult get(boolean verboseErrorsEnabled,
                                          int readTimeout) {
    WebTarget target = client.target(baseUrl);
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    if (readTimeout > 0) {
      invocationBuilder.property(READ_TIMEOUT, readTimeout);
    }
    Response response = invocationBuilder.get();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingAgentHandlerException(response);
    }
    return jsonSerializer().deserialize(response.readEntity(String.class), SampleDataMessageModelResult.class);
  }

}
