
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.glassfish.jersey.client.ClientProperties.READ_TIMEOUT;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException.newToolingAgentHandlerException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;

import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;

import com.mulesoft.agent.external.handlers.tooling.TestConnectionRequest;
import com.mulesoft.agent.external.handlers.tooling.serialization.TestConnectionRequestSerializer;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

/**
 * Connection web resource.
 *
 * @since 4.0
 */
public class Connection {

  private String baseUrl;
  private Client client;

  public Connection(String baseUrl, Client client) {
    this.baseUrl = (baseUrl + "/connection");
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * GET operation, does connectivity testing over the componentId for the application.
   *
   * @param verboseErrorsEnabled flag that defines if it has to be verbose the response in case of errors/failures.
   * @return {@link ConnectivityTestingResponse} with the response.
   * @throws ToolingAgentHandlerException if there was an error.
   * @param verboseErrorsEnabled
   */
  public ConnectivityTestingResponse get(boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
    final Invocation.Builder invocationBuilder = getBuilder(verboseErrorsEnabled, readTimeout);
    Response response = invocationBuilder.get();
    return readConnectivityTestingResponse(response);
  }

  public ConnectivityTestingResponse put(TestConnectionRequest request, boolean verboseErrorsEnabled, int readTimeout)
      throws ToolingAgentHandlerException {
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = getBuilder(verboseErrorsEnabled, readTimeout);
    Response response = invocationBuilder.put(
                                              Entity.json(TestConnectionRequestSerializer.create().serialize(request)));

    return readConnectivityTestingResponse(response);
  }

  private ConnectivityTestingResponse readConnectivityTestingResponse(Response response) throws ToolingAgentHandlerException {
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingAgentHandlerException(response);
    }

    return new ConnectivityTestingResponseSerializer().deserialize(response.readEntity(String.class));
  }

  private Invocation.Builder getBuilder(boolean verboseErrorsEnabled, int readTimeout) {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    if (readTimeout > 0) {
      invocationBuilder.property(READ_TIMEOUT, readTimeout);
    }
    return invocationBuilder;
  }
}
