/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection;

import org.mule.runtime.api.connection.serialization.ErrorTypeSerializer;
import org.mule.runtime.api.message.ErrorType;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.util.function.Function;

/**
 * Custom serializer which provides the capability of deserialize {@link ConnectivityTestingResponse} instances
 *
 * @since 4.0
 */
public class ConnectivityTestingResponseSerializer {

  private static final String VALIDATION_STATUS = "validationStatus";
  private static final String MESSAGE = "message";
  private static final String ERROR_TYPE = "errorType";
  private static final String REASON = "reason";
  private static final String EXCEPTION = "exception";
  private ErrorTypeSerializer errorTypeSerializer = ErrorTypeSerializer.create();

  public ConnectivityTestingResponse deserialize(String response) {
    JsonElement parse = new JsonParser().parse(response);
    JsonObject asJsonObject = parse.getAsJsonObject();
    boolean validationStatus;
    if (asJsonObject.has(VALIDATION_STATUS)) {
      validationStatus = asJsonObject.getAsJsonPrimitive(VALIDATION_STATUS).getAsBoolean();
    } else {
      throw new IllegalStateException("The deserialized ConnectivityTestingResponse doesn't provide a 'validationStatus'");
    }

    ErrorType errorType = doIfPresent(ERROR_TYPE, asJsonObject,
                                      (object) -> errorTypeSerializer.deserialize(object.getAsJsonObject(ERROR_TYPE).toString()));
    String reason = doIfPresent(REASON, asJsonObject, (object) -> object.getAsJsonPrimitive(REASON).getAsString());
    String message = doIfPresent(MESSAGE, asJsonObject, (object) -> object.getAsJsonPrimitive(MESSAGE).getAsString());
    String exception = doIfPresent(EXCEPTION, asJsonObject, (object) -> object.getAsJsonPrimitive(EXCEPTION).getAsString());

    return new ConnectivityTestingResponse(validationStatus, message, errorType, reason, exception);
  }

  private <T> T doIfPresent(String memberName, JsonObject jsonObject, Function<JsonObject, T> function) {
    return jsonObject.has(memberName) ? function.apply(jsonObject) : null;
  }
}
