/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.applications.applicationId;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tooling.agent.rest.client.UriUtils;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.cache.Cache;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.Components;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.dataWeave.DataWeave;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationId {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String baseUrl;
    private Client client;
    public final Components components;
    public final DataWeave dataweave;
    public Cache cache;

    public ApplicationId(String baseUrl, Client client, String uriParam) {
        this.baseUrl = UriUtils.resolveUri(baseUrl, uriParam);
        this.client = client;
        this.components = new Components(this.getBaseUri(), this.getClient());
        this.dataweave = new DataWeave(this.getBaseUri(), this.getClient());
        this.cache = new Cache(this.getBaseUri(), this.getClient());
    }

    private Client getClient() {
        return this.client;
    }

    private String getBaseUri() {
        return this.baseUrl;
    }

    public void delete(boolean verboseErrorsEnabled, int readTimeout) {
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        invocationBuilder.async().delete((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                    ApplicationId.this.logger.error("Could not dispose tooling application", (Throwable)ToolingAgentHandlerException.newToolingAgentHandlerException(response));
                }
            }

            public void failed(Throwable throwable) {
                ApplicationId.this.logger.error("Error while disposing tooling application", throwable);
            }
        });
    }
}

