/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.sessions;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.extension.api.persistence.metadata.MetadataKeysResultJsonSerializer;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.api.serialization.Serializer;
import org.slf4j.MDC;

public class Keys {
    private static final String IGNORE_CACHE_QUERY_PARAM = "ignoreCache";
    private final String baseUrl;
    private Client client;
    private Serializer serializer;

    public Keys(String baseUrl, Client client, Serializer serializer) {
        this.baseUrl = baseUrl + "/keys";
        this.client = client;
        this.serializer = serializer;
    }

    public MetadataResult<MetadataKeysContainer> put(ComponentElementDeclaration componentElementDeclaration, boolean ignoreCache, boolean verboseErrorsEnabled) {
        WebTarget target = this.client.target(this.baseUrl);
        target = target.queryParam(IGNORE_CACHE_QUERY_PARAM, new Object[]{ignoreCache});
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder.header("X-B3-TraceId", (Object)MDC.get((String)"X-B3-TraceId"));
        Response response = invocationBuilder.put(Entity.entity((Object)this.serializer.serialize((Object)componentElementDeclaration), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return new MetadataKeysResultJsonSerializer().deserialize((String)response.readEntity(String.class));
    }
}

