/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client;

import static java.lang.String.format;
import static java.net.URLDecoder.decode;
import static java.net.URLEncoder.encode;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;

public class UriUtils {

  private static final String UTF_8 = "UTF-8";

  public static String resolveUri(String parent, String uri) {
    URI parentUri;
    try {
      parentUri = new URL(parent + "/").toURI();
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    URI resolvedUri;
    try {
      if (uri.contains("%")) {
        resolvedUri = parentUri.resolve(decode(uri, UTF_8));
      } else {
        try {
          resolvedUri = parentUri.resolve(uri);
          if (resolvedUri.getPath() == null) {
            resolvedUri = parentUri.resolve(encode(uri, UTF_8));
          }
        } catch (IllegalArgumentException e) {
          resolvedUri = parentUri.resolve(encode(uri, UTF_8));
        }
      }
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }

    if (!resolvedUri.getPath().startsWith(parentUri.getPath())) {
      throw new IllegalArgumentException(format("Invalid URI '%s'", uri));
    }

    try {
      return parentUri.resolve(encode(uri, UTF_8)).toString();
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }

  }

}
