/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client.tooling.sessions;

import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException.newToolingAgentHandlerException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;
import static org.mule.tooling.agent.rest.client.tooling.sessions.SessionId.REQUEST_ID_HEADER_NAME;

import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.ConnectivityTestingResponseSerializer;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.MDC;

//TODO: (CMTS-38) TIDY THIS, MOST OF THE CODE WAS COPIED FROM THE OTHER CONNECTION RESOURCE
public class Connection {

  private static final String CONFIG_NAME_QUERY_PARAM = "configName";

  private String baseUrl;
  private Client client;

  public Connection(String baseUrl, Client client) {
    this.baseUrl = (baseUrl + "/connection");
    this.client = client;
  }

  public ConnectivityTestingResponse get(String configName, boolean verboseErrorsEnabled) throws ToolingAgentHandlerException {
    WebTarget target = this.client.target(this.baseUrl);
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    target = target.queryParam(CONFIG_NAME_QUERY_PARAM, configName);

    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request();
    invocationBuilder.header(REQUEST_ID_HEADER_NAME, MDC.get(REQUEST_ID_HEADER_NAME));

    Response response = invocationBuilder.get();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingAgentHandlerException(response);
    }
    return readConnectivityTestingResponse(response);
  }

  private ConnectivityTestingResponse readConnectivityTestingResponse(Response response) throws ToolingAgentHandlerException {
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingAgentHandlerException(response);
    }

    return new ConnectivityTestingResponseSerializer().deserialize(response.readEntity(String.class));
  }

}
