/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client.tooling.sessions;

import static javax.ws.rs.client.Entity.entity;
import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException.newToolingAgentHandlerException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;
import static org.mule.tooling.agent.rest.client.tooling.sessions.SessionId.REQUEST_ID_HEADER_NAME;
import static org.mule.tooling.api.serialization.SerializerFactory.jsonSerializer;

import org.mule.tooling.api.request.session.DeclarationSessionCreationRequest;
import org.mule.tooling.api.serialization.Serializer;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.MDC;

public class DeclarationSessions {

  private String baseUrl;
  private Client client;
  private Serializer serializer;

  public DeclarationSessions(String toolingApiUrl, Client client) {
    this.baseUrl = toolingApiUrl + "/declaration-sessions";
    this.client = client;
    this.serializer = jsonSerializer();
  }

  public String post(DeclarationSessionCreationRequest declarationSessionCreationRequest, boolean verboseErrorsEnabled) {
    WebTarget target = this.client.target(this.baseUrl);
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);

    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request();
    invocationBuilder.header(REQUEST_ID_HEADER_NAME, MDC.get(REQUEST_ID_HEADER_NAME));

    Response response = invocationBuilder
        .post(entity(serializer.serialize(declarationSessionCreationRequest), APPLICATION_JSON_TYPE));
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingAgentHandlerException(response);
    }
    return response.readEntity(String.class);
  }

  public SessionId sessionId(String sessionId) {
    return new SessionId(baseUrl, client, serializer, sessionId);
  }
}
