/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static java.util.Optional.empty;
import static java.util.concurrent.TimeUnit.MILLISECONDS;
import static java.util.concurrent.TimeUnit.SECONDS;
import static org.awaitility.Awaitility.with;

import org.mule.tooling.client.test.BaseToolingBootstrapTestCase;
import org.mule.tooling.client.test.junit4.annotations.MuleHome;
import org.mule.tooling.client.test.junit4.annotations.NeedsRuntime;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

import org.awaitility.Duration;
import org.junit.Before;

@NeedsRuntime
public abstract class AbstractRestAgentToolingServiceTestCase extends BaseToolingBootstrapTestCase {

  protected static final int DEFAULT_START_TIMEOUT = 50000;
  protected static final long AGENT_CONNECT_TIMEOUT_SECS = 15;
  protected static final long AGENT_READ_TIMEOUT_SECS = 60;

  @MuleHome
  protected static File muleHome;

  protected RestAgentToolingService restAgentToolingService;


  @Before
  public final void setupMuleAgentService() throws MalformedURLException, UnknownHostException {
    restAgentToolingService = createRestAgentToolingService(SECONDS.toMillis(AGENT_CONNECT_TIMEOUT_SECS),
                                                            SECONDS.toMillis(AGENT_READ_TIMEOUT_SECS));
  }

  protected RestAgentToolingService createRestAgentToolingService(long agentConnectTimeoutSecs, long agentReadTimeoutSecs)
      throws MalformedURLException, UnknownHostException {
    RestAgentToolingService restAgentToolingService = new RestAgentToolingService();
    restAgentToolingService
        .setToolingApiUrl(new URL(agentProtocol, InetAddress.getLocalHost().getHostName(), agentPort, "/mule/tooling"),
                          agentConnectTimeoutSecs, agentReadTimeoutSecs, empty(), empty(),
                          "");
    setMuleVersion(restAgentToolingService);

    with().timeout(new Duration(getStartUpTimeout(), SECONDS))
        .and().with().pollInterval(300, MILLISECONDS).and().with()
        .pollDelay(200, MILLISECONDS).await("Waiting for Agent Tooling Service to be operational")
        .until(restAgentToolingService::isOperational);
    return restAgentToolingService;
  }

  protected void setMuleVersion(RestAgentToolingService restAgentToolingService) {
    restAgentToolingService.setMuleVersion(muleVersion);
  }

  protected long getStartUpTimeout() {
    return DEFAULT_START_TIMEOUT;
  }

}
