/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client.filter;

import static javax.ws.rs.core.HttpHeaders.AUTHORIZATION;
import static org.apache.commons.lang3.StringUtils.isEmpty;

import java.io.IOException;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;

public class AuthorizationRequestFilter implements ClientRequestFilter, ContainerRequestFilter {

  private final String authorizationToken;

  public AuthorizationRequestFilter(String authorizationToken) {
    this.authorizationToken = authorizationToken;
  }

  @Override
  public void filter(ClientRequestContext requestContext) {
    if (!isEmpty(authorizationToken)) {
      requestContext.getHeaders().add(AUTHORIZATION, authorizationToken);
    }
  }

  @Override
  public void filter(ContainerRequestContext requestContext) throws IOException {
    if (!isEmpty(authorizationToken)) {
      requestContext.getHeaders().add(AUTHORIZATION, authorizationToken);
    }
  }
}
