
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.domains.domainId.components.componentId;

import static org.mule.tooling.agent.rest.client.UriUtils.resolveUri;

import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.Connection;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.valueProviders.ValueProviders;

import javax.ws.rs.client.Client;

/**
 * Component web resource.
 *
 * @since 4.0
 */
public class ComponentId {

  private String baseUrl;
  private Client client;
  public final Connection connection;
  public final ValueProviders valueProviders;

  public ComponentId(String baseUrl, Client client, String uriParam) {
    this.baseUrl = resolveUri(baseUrl, uriParam);
    this.client = client;
    connection = new Connection(getBaseUri(), getClient());
    valueProviders = new ValueProviders(getBaseUri(), getClient());
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

}
