/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static java.util.Collections.emptyMap;

import java.io.File;
import java.io.InputStream;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature("Remote Runtime Tooling Service - Applications without deployment properties")
@Story("DeployToolingArtifact")
public class DeployApplicationWithoutDeploymentPropertiesTestCase extends DeployApplicationTestCase {

  @Override
  protected void setMuleVersion(RestAgentToolingService restAgentToolingService) {
    restAgentToolingService.setMuleVersion(null);
  }

  protected String doDeployDomain(File location) {
    return restAgentToolingService.deployDomain(null, location, emptyMap());
  }

  protected String doDeployDomain(InputStream inputStream) {
    return restAgentToolingService.deployDomain(null, inputStream, emptyMap());
  }

  protected String doDeployApplication(File emailAppLocation) {
    return restAgentToolingService.deployApplication(null, emailAppLocation, emptyMap());
  }

  protected String doDeployApplication(File location, String domainId) {
    return restAgentToolingService.deployApplication(null, location, domainId, emptyMap());
  }

  protected String doDeployApplication(InputStream inputStream) {
    return restAgentToolingService.deployApplication(null, inputStream, emptyMap());
  }

  protected String doDeployApplication(InputStream inputStream, String domainId) {
    return restAgentToolingService.deployApplication(null, inputStream, domainId, emptyMap());
  }

}
