/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.sessions;

import java.net.ConnectException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.tooling.agent.rest.client.UriUtils;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.sessions.Connection;
import org.mule.tooling.agent.rest.client.tooling.sessions.FieldValues;
import org.mule.tooling.agent.rest.client.tooling.sessions.Metadata;
import org.mule.tooling.agent.rest.client.tooling.sessions.SampleData;
import org.mule.tooling.agent.rest.client.tooling.sessions.Values;
import org.mule.tooling.api.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SessionId {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final String REQUEST_ID_HEADER_NAME = "X-B3-TraceId";
    static final String MDC_TRACE_ID_KEY = "traceId";
    private final String id;
    private final String baseUrl;
    private final Client client;
    public Values values;
    public FieldValues fieldValues;
    public Metadata metadata;
    public Connection connection;
    public SampleData sampleData;

    public SessionId(String baseUrl, Client client, Serializer serializer, String id) {
        this.baseUrl = UriUtils.resolveUri(baseUrl, id);
        this.id = id;
        this.values = new Values(this.baseUrl, client, serializer);
        this.fieldValues = new FieldValues(this.baseUrl, client, serializer);
        this.metadata = new Metadata(this.baseUrl, client, serializer);
        this.connection = new Connection(this.baseUrl, client);
        this.sampleData = new SampleData(this.baseUrl, client, serializer);
        this.client = client;
    }

    public void delete() {
        WebTarget target = this.client.target(this.baseUrl);
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header(REQUEST_ID_HEADER_NAME, (Object)MDC.get((String)MDC_TRACE_ID_KEY));
        invocationBuilder.async().delete((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                    SessionId.this.logger.error("Could not dispose declaration session", (Throwable)ToolingAgentHandlerException.newToolingAgentHandlerException(response));
                }
            }

            public void failed(Throwable throwable) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
                if (rootCause != null && rootCause instanceof ConnectException) {
                    SessionId.this.logger.warn(String.format("Could not dispose declaration session: %s Mule Runtime may has been stopped. %s", SessionId.this.id, throwable.getCause().getMessage()));
                } else {
                    SessionId.this.logger.error("Error while disposing declaration session", throwable);
                }
            }
        });
    }
}

