/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client;

import com.mulesoft.agent.domain.tooling.BundleDescriptor;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;
import com.mulesoft.agent.external.handlers.tooling.TestConnectionRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclarationVisitor;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.agent.rest.client.ConnectionValidationResultFactory;
import org.mule.tooling.agent.rest.client.VersionUtils;
import org.mule.tooling.agent.rest.client.api.ToolingServiceAPIClient;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.exceptions.model.ErrorCode;
import org.mule.tooling.agent.rest.client.exceptions.model.ErrorEntity;
import org.mule.tooling.agent.rest.client.filter.AuthorizationRequestFilter;
import org.mule.tooling.agent.rest.client.service.ServiceFunction;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.messageHistory.AgentTrackingNotificationResponse;
import org.mule.tooling.agent.rest.client.tooling.applications.model.ApplicationsPUTBody;
import org.mule.tooling.agent.rest.client.tooling.domains.model.DomainsPUTBody;
import org.mule.tooling.api.request.session.DeclarationSessionCreationRequest;
import org.mule.tooling.api.request.values.FieldValuesRequest;
import org.mule.tooling.api.request.values.ValuesRequest;
import org.mule.tooling.api.sampledata.SampleDataMessageModelResult;
import org.mule.tooling.client.api.configuration.agent.proxy.ProxyConfig;
import org.mule.tooling.client.api.configuration.ssl.SslConfiguration;
import org.mule.tooling.client.api.connectivity.BundleNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.DeploymentException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.TimeoutException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAgentToolingService
implements RuntimeToolingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MULE_4_1_5 = "4.1.5-SNAPSHOT";
    private static final String MULE_4_2_0 = "4.2.0-SNAPSHOT";
    private ToolingServiceAPIClient client;
    private URL url;
    private int defaultReadTimeout;
    private static boolean VERBOSE_ERROR_ENABLED = true;
    private Optional<SSLContext> sslContext;
    private String muleVersion;
    private String authorizationToken;

    @Override
    public void setToolingApiUrl(URL url, long defaultConnectTimeout, long defaultReadTimeout, Optional<SslConfiguration> sslConfiguration, Optional<ProxyConfig> proxyConfig, String authorizationToken) {
        Objects.requireNonNull(url, "url cannot be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configuring using tooling API URL:{}, defaultConnectTimeout:{}ms, defaultReadTimeout:{}ms", new Object[]{url, defaultConnectTimeout, defaultReadTimeout});
        }
        this.sslContext = sslConfiguration.map(configuration -> {
            try {
                FileInputStream keyStoreFile = new FileInputStream(configuration.getKeyStoreConfig().getKeyStoreFile());
                FileInputStream trustStoreFile = new FileInputStream(configuration.getTrustStoreConfig().getTrustStoreFile());
                KeyStore trustStore = KeyStore.getInstance("JKS");
                trustStore.load(trustStoreFile, configuration.getKeyStoreConfig().getKeyStorePassword().toCharArray());
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(keyStoreFile, configuration.getTrustStoreConfig().getTrustStorePassword().toCharArray());
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                KeyManagerFactory sunX509 = KeyManagerFactory.getInstance("SunX509");
                sunX509.init(keyStore, configuration.getKeyStoreConfig().getKeyStorePassword().toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                trustManagerFactory.init(trustStore);
                ctx.init(sunX509.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
                HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
                return Optional.of(ctx);
            }
            catch (Exception e) {
                throw new ToolingException("Error while configuring mutual SSL to connect to the Mule Agent REST API.", (Throwable)e);
            }
        }).orElse(Optional.empty());
        this.defaultReadTimeout = Long.valueOf(defaultReadTimeout).intValue();
        this.client = ToolingServiceAPIClient.create(url.toString(), Long.valueOf(defaultConnectTimeout).intValue(), this.defaultReadTimeout, this.sslContext, proxyConfig, authorizationToken);
        this.authorizationToken = authorizationToken;
        this.url = url;
    }

    @Override
    public boolean isOperational() {
        ClientBuilder builder = (ClientBuilder)ClientBuilder.newBuilder().property("jersey.config.client.connectTimeout", (Object)1000);
        this.sslContext.ifPresent(sslContext -> builder.sslContext(sslContext));
        Client client = ((ClientBuilder)builder.register((Object)new AuthorizationRequestFilter(this.authorizationToken))).build();
        try {
            client.target(this.url.toString()).request().buildGet().invoke();
            return true;
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                return false;
            }
            throw new ToolingException("Error while checking if Mule Agent REST service is available", (Throwable)e);
        }
    }

    @Override
    public void setMuleVersion(String muleVersion) {
        this.muleVersion = muleVersion;
    }

    public List<String> listApplicationsId() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/");
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.get(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).stream().map(applicationsGETResponse -> applicationsGETResponse.getApplicationId()).collect(Collectors.toList()), this.createDescription("list(applications)"));
        }
        catch (ToolingAgentHandlerException e) {
            throw this.handleToolingAgentHandlerException(e);
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while getting retrieving applications", e);
        }
    }

    @Override
    public String deployApplication(String id, File appLocation, String domainName, Map<String, String> deploymentProperties) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/applications/{} appLocation:[{}], domain:{}", new Object[]{id, appLocation, domainName != null ? domainName : ""});
        }
        try {
            if (this.supportsDeploymentProperties()) {
                return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(new ApplicationsPUTBody().withId(id).withAppLocation(appLocation.getAbsolutePath()).withDomainName(domainName).withDeploymentProperties(deploymentProperties), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription(String.format("deploy(application:%s)", id)));
            }
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(new ApplicationsPUTBody(id, appLocation.getAbsolutePath(), domainName), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription(String.format("deploy(application:%s)", id)));
        }
        catch (Exception e) {
            throw this.serviceExceptionOr(e, () -> this.newDeploymentException(String.format("Couldn't deploy the application: '%s'", id), e));
        }
    }

    private String createDescription(String method) {
        return RuntimeToolingService.class.getSimpleName() + "#" + method;
    }

    @Override
    public String deployDomain(String id, File domainLocation, Map<String, String> deploymentProperties) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/domains/{} domainLocation:[{}]", (Object)id, (Object)domainLocation);
        }
        try {
            if (this.supportsDeploymentProperties()) {
                return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.put(new DomainsPUTBody().withId(id).withDomainLocation(domainLocation.getAbsolutePath()).withDeploymentProperties(deploymentProperties), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getDomainId(), this.createDescription(String.format("deploy(domain:%s)", id)));
            }
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.put(new DomainsPUTBody().withId(id).withDomainLocation(domainLocation.getAbsolutePath()), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getDomainId(), this.createDescription(String.format("deploy(domain:%s)", id)));
        }
        catch (Exception e) {
            throw this.serviceExceptionOr(e, () -> this.newDeploymentException(String.format("Couldn't deploy the domain: '%s'", id), e));
        }
    }

    @Override
    public String deployDomain(String id, InputStream inputStream, Map<String, String> deploymentProperties) throws DeploymentException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/domains/{} inputStream, id");
        }
        try {
            if (this.supportsDeploymentProperties()) {
                return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.put(new DomainsPUTBody().withId(id).withContent(this.toByteArray(inputStream)).withDeploymentProperties(deploymentProperties), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getDomainId(), this.createDescription("deploy(domain)"));
            }
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.put(inputStream, id, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getDomainId(), this.createDescription("deploy(domain)"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOr(e, () -> this.newDeploymentException(String.format("Couldn't deploy the domain: '%s'", id), e));
        }
    }

    private byte[] toByteArray(InputStream inputStream) {
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ToolingException((Throwable)e);
        }
    }

    @Override
    public String deployApplication(String id, InputStream inputStream, Map<String, String> deploymentProperties) throws DeploymentException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/applications/{} inputStream", (Object)id);
        }
        try {
            if (this.supportsDeploymentProperties()) {
                return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(new ApplicationsPUTBody().withId(id).withContent(this.toByteArray(inputStream)).withDeploymentProperties(deploymentProperties), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription("deploy(application)"));
            }
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(inputStream, id, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription("deploy(application)"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOr(e, () -> this.newDeploymentException(String.format("Couldn't deploy the application: '%s'", id), e));
        }
    }

    @Override
    public String deployApplication(String id, InputStream inputStream, String domainName, Map<String, String> deploymentProperties) throws DeploymentException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/applications/{} inputStream", (Object)id);
        }
        try {
            if (this.supportsDeploymentProperties()) {
                return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(new ApplicationsPUTBody().withId(id).withContent(this.toByteArray(inputStream)).withDomainName(domainName).withDeploymentProperties(deploymentProperties), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription("deploy(application)"));
            }
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(inputStream, id, domainName, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription("deploy(application)"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOr(e, () -> this.newDeploymentException(String.format("Couldn't deploy the application: '%s'", id), e));
        }
    }

    @Override
    public void disposeApplication(String applicationId) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/applications/{}", (Object)applicationId);
        }
        try {
            ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId(applicationId).delete(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout), this.createDescription("dispose(application)"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Unknown error while disposing application, for applicationId: %s", applicationId), e);
        }
    }

    @Override
    public void disposeDomain(String domainId) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/domains/{}", (Object)domainId);
        }
        try {
            ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId(domainId).delete(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout), this.createDescription("dispose(domain)"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Unknown error while disposing domain, for domainId: %s", domainId), e);
        }
    }

    @Override
    public ConnectionValidationResult testConnectionApplication(String applicationId, String componentId, long readTimeout) throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/connection", (Object)applicationId, (Object)componentId);
        }
        try {
            ConnectivityTestingResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentId).connection.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("testConnection(application)"));
            return response.getValidationStatus() != false ? ConnectionValidationResultFactory.success() : ConnectionValidationResultFactory.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while doing connectivity testing on application", e);
        }
    }

    @Override
    public ConnectionValidationResult testConnectionDomain(String domainId, String componentId, long readTimeout) throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/domains/{}/components/{}/connection", (Object)domainId, (Object)componentId);
        }
        try {
            ConnectivityTestingResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId((String)domainId).components.componentId((String)componentId).connection.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("testConnection(domain)"));
            return response.getValidationStatus() != false ? ConnectionValidationResultFactory.success() : ConnectionValidationResultFactory.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while doing connectivity testing on application", e);
        }
    }

    @Override
    public ConnectionValidationResult testConnection(List<BundleDescriptor> dependencies, ArtifactDeclaration artifactDeclaration, String componentId, long readTimeout) throws UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/components/{}/connection", (Object)componentId);
        }
        try {
            ConnectivityTestingResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.components.componentId((String)componentId).connection.put(this.createRequest(dependencies, artifactDeclaration), VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("testConnection(temporaryArtifact)"));
            return response.getValidationStatus() != false ? ConnectionValidationResultFactory.success() : ConnectionValidationResultFactory.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while doing connectivity testing on application", e);
        }
    }

    @Override
    public PreviewResponse runDataWeaveApplication(String applicationId, PreviewRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("POST:tooling/applications/{}/dataweave/execute", (Object)applicationId);
        }
        try {
            PreviewResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).dataweave.execute.post(request, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout), this.createDescription("runDataWeave(application)"));
            return response;
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while executing dataweave script", e);
        }
    }

    @Override
    public PreviewResponse runDataWeaveDomain(String domainId, PreviewRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("POST:tooling/domains/{}/dataweave/execute", (Object)domainId);
        }
        try {
            PreviewResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId((String)domainId).dataweave.execute.post(request, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout), this.createDescription("runDataWeave(domain)"));
            return response;
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while executing dataweave script", e);
        }
    }

    private TestConnectionRequest createRequest(List<BundleDescriptor> dependencies, ArtifactDeclaration artifactDeclaration) {
        TestConnectionRequest request = new TestConnectionRequest();
        request.setArtifactDeclaration(artifactDeclaration);
        request.setDependencies(dependencies);
        return request;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeysApplication(String applicationId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/keys", (Object)applicationId, (Object)componentLocation);
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentLocation).keys.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("getMetadataKeys(application)"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while getting Metadata keys", e);
        }
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeysDomain(String domainId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/domains/{}/components/{}/keys", (Object)domainId, (Object)componentLocation);
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId((String)domainId).components.componentId((String)componentLocation).keys.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("getMetadataKeys(domain)"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while getting Metadata keys", e);
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String applicationId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        return this.getMetadata(applicationId, componentLocation, readTimeout);
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String applicationId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        return this.getMetadata(applicationId, componentLocation, readTimeout);
    }

    private <T extends ComponentModel> MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(String applicationId, String componentLocation, long readTimeout) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/metadata", (Object)applicationId, (Object)componentLocation);
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentLocation).metadata.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue(), this.supportsReducedJsonSerialization()), this.createDescription("getMetadata"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while getting Metadata", e);
        }
    }

    @Override
    public void disposeApplicationMetadataCache(String applicationId, String hashKey) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/applications/{}/cache/{}", (Object)applicationId, (Object)hashKey);
        }
        this.doDisposeMetadataCache(() -> {
            this.client.tooling.applications.applicationId((String)applicationId).cache.hashKey(hashKey).delete(VERBOSE_ERROR_ENABLED);
            return null;
        }, this.createDescription("disposeApplicationMetadataCache"), "Error while disposing Metadata");
    }

    private <OutputType> OutputType doDisposeMetadataCache(Supplier<OutputType> function, String serviceMethod, String errorMessage) {
        try {
            return ServiceFunction.serviceCallWrapper(function, this.createDescription(serviceMethod));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while disposing Metadata cache", e);
        }
    }

    @Override
    public void disposeDomainMetadataCache(String domainId, String hashKey) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/domains/{}/cache/{}", (Object)domainId, (Object)hashKey);
        }
        this.doDisposeMetadataCache(() -> {
            this.client.tooling.domains.domainId((String)domainId).cache.hashKey(hashKey).delete(VERBOSE_ERROR_ENABLED);
            return null;
        }, this.createDescription("disposeDomainMetadataCache"), "Error while disposing Metadata");
    }

    @Override
    public void enableMessageHistory(String applicationName) throws NoSuchApplicationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/applications/{}/messagehistory/", (Object)applicationName);
        }
        try {
            this.client.tooling.applications.applicationName((String)applicationName).messageHistory.put(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout);
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while enabling application for message history", e);
        }
    }

    @Override
    public List<AgentTrackingNotificationResponse> consumeMessageHistoryNotifications(String applicationName, int chunkSize) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/messagehistory/", (Object)applicationName);
        }
        try {
            return this.client.tooling.applications.applicationName((String)applicationName).messageHistory.get(chunkSize, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout);
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while getting application notifications for message history", e);
        }
    }

    @Override
    public void disableMessageHistory(String applicationName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/applications/{}/messagehistory/", (Object)applicationName);
        }
        try {
            this.client.tooling.applications.applicationName((String)applicationName).messageHistory.delete(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout);
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while disabling application for message history", e);
        }
    }

    @Override
    public ValueResult getValuesApplication(String applicationId, String location, String providerName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/valueProviders/{}", new Object[]{applicationId, location, providerName});
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)location).valueProviders.get(providerName, this.defaultReadTimeout), this.createDescription("getValues(application"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Unknown error while trying to resolve Values for the ValueProvider [%s] located in [%s] of the application with ID [%s]", providerName, location, applicationId), e);
        }
    }

    @Override
    public ValueResult getValuesDomain(String domainId, String location, String providerName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/domains/{}/components/{}/valueProviders/{}", new Object[]{domainId, location, providerName});
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId((String)domainId).components.componentId((String)location).valueProviders.get(providerName, this.defaultReadTimeout), this.createDescription("getValues(domain)"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Unknown error while trying to resolve Values for the ValueProvider [%s] located in [%s] of the domain with ID [%s]", providerName, location, domainId), e);
        }
    }

    @Override
    public SampleDataMessageModelResult getSampleDataApplication(String applicationId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/sampledata", (Object)applicationId, (Object)componentLocation);
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentLocation).sampleData.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("getSampleData"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Unknown error while getting Metadata", e);
        }
    }

    @Override
    public String createDeclarationSession(DeclarationSessionCreationRequest declarationSessionCreationRequest) {
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.sessions.post(declarationSessionCreationRequest, VERBOSE_ERROR_ENABLED), this.createDescription("newDeclarationSession()"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException("Error while creating a new DeclarationSession", e);
        }
    }

    @Override
    public void disposeDeclarationSession(String sessionId) {
        try {
            ServiceFunction.serviceCallWrapper(() -> this.client.tooling.sessions.sessionId(sessionId).delete(), this.createDescription("disposeDeclarationSession()"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Error while disposing a DeclarationSession with id: '%s'", sessionId), e);
        }
    }

    @Override
    public ValueResult getValues(String sessionId, ParameterizedElementDeclaration parameterizedElementDeclaration, final String providerName) {
        try {
            final Reference valuesRequestReference = new Reference();
            parameterizedElementDeclaration.accept(new ParameterizedElementDeclarationVisitor(){

                public void visitConfigurationElementDeclaration(ConfigurationElementDeclaration configurationElementDeclaration) {
                    valuesRequestReference.set((Object)new ValuesRequest(configurationElementDeclaration, providerName));
                }

                public void visitConnectionElementDeclaration(ConnectionElementDeclaration connectionElementDeclaration) {
                    valuesRequestReference.set((Object)new ValuesRequest(connectionElementDeclaration, providerName));
                }

                public void visitComponentElementDeclaration(ComponentElementDeclaration componentElementDeclaration) {
                    valuesRequestReference.set((Object)new ValuesRequest(componentElementDeclaration, providerName));
                }
            });
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.sessions.sessionId((String)sessionId).values.put((ValuesRequest)valuesRequestReference.get(), VERBOSE_ERROR_ENABLED), this.createDescription("getValues()"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Error while getting values for providerName: '%s', element: '%s', extension: '%s', session: '%s'", providerName, parameterizedElementDeclaration.getName(), parameterizedElementDeclaration.getDeclaringExtension(), sessionId), e);
        }
    }

    @Override
    public ValueResult getFieldValues(String sessionId, ParameterizedElementDeclaration parameterizedElementDeclaration, final String providerName, final String targetSelector) {
        try {
            final Reference fieldValuesRequestReference = new Reference();
            parameterizedElementDeclaration.accept(new ParameterizedElementDeclarationVisitor(){

                public void visitComponentElementDeclaration(ComponentElementDeclaration componentElementDeclaration) {
                    fieldValuesRequestReference.set((Object)new FieldValuesRequest(componentElementDeclaration, providerName, targetSelector));
                }
            });
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.sessions.sessionId((String)sessionId).fieldValues.put((FieldValuesRequest)fieldValuesRequestReference.get(), VERBOSE_ERROR_ENABLED), this.createDescription("getFieldValues()"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Error while getting field values for providerName: '%s', targetSelector: '%s', element: '%s', extension: '%s', session: '%s'", providerName, targetSelector, parameterizedElementDeclaration.getName(), parameterizedElementDeclaration.getDeclaringExtension(), sessionId), e);
        }
    }

    @Override
    public MetadataResult<ComponentMetadataTypesDescriptor> getComponentMetadata(String sessionId, ComponentElementDeclaration componentElementDeclaration, boolean ignoreCache) {
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.sessions.sessionId((String)sessionId).metadata.put(componentElementDeclaration, ignoreCache, VERBOSE_ERROR_ENABLED), this.createDescription("getComponentMetadata()"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Error while resolving metadata for element: '%s', extension: '%s', session: '%s'", componentElementDeclaration.getName(), componentElementDeclaration.getDeclaringExtension(), sessionId), e);
        }
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getComponentMetadataKeys(String sessionId, ComponentElementDeclaration componentElementDeclaration, boolean ignoreCache) {
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.sessions.sessionId((String)sessionId).metadata.keys.put(componentElementDeclaration, ignoreCache, VERBOSE_ERROR_ENABLED), this.createDescription("getComponentMetadataKeys()"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Error while getting metadata keys from element: '%s', extension: '%s', session: '%s'", componentElementDeclaration.getDeclaringExtension(), componentElementDeclaration.getName(), sessionId), e);
        }
    }

    @Override
    public SampleDataMessageModelResult getSampleData(String sessionId, ComponentElementDeclaration componentElementDeclaration) {
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.sessions.sessionId((String)sessionId).sampleData.put(componentElementDeclaration, VERBOSE_ERROR_ENABLED), this.createDescription("getSampleData()"));
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Error while getting metadata keys from element: '%s', extension: '%s', session: '%s'", componentElementDeclaration.getDeclaringExtension(), componentElementDeclaration.getName(), sessionId), e);
        }
    }

    @Override
    public ConnectionValidationResult testConnection(String sessionId, String configName) {
        try {
            ConnectivityTestingResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.sessions.sessionId((String)sessionId).connection.get(configName, VERBOSE_ERROR_ENABLED), this.createDescription("testConnection"));
            return response.getValidationStatus() != false ? ConnectionValidationResultFactory.success() : ConnectionValidationResultFactory.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (Exception e) {
            throw this.serviceExceptionOrToolingException(String.format("Error while doing connectivity testing on config: '%s', session: '%s'", configName, sessionId), e);
        }
    }

    private boolean supportsDeploymentProperties() {
        return this.muleVersion != null && VersionUtils.isVersionGreaterOrEqualThan(this.muleVersion, MULE_4_1_5);
    }

    private boolean supportsReducedJsonSerialization() {
        return this.muleVersion != null && VersionUtils.isVersionGreaterOrEqualThan(this.muleVersion, MULE_4_2_0);
    }

    private ToolingException serviceExceptionOrToolingException(String message, Exception e) {
        return this.serviceExceptionOr(e, () -> {
            if (e instanceof ToolingAgentHandlerException) {
                return this.handleToolingAgentHandlerException((ToolingAgentHandlerException)e);
            }
            return new ToolingException(message, (Throwable)e);
        });
    }

    private ToolingException serviceExceptionOr(Exception e, Supplier<ToolingException> supplier) {
        if (e.getCause() instanceof ConnectException) {
            return new ServiceUnavailableException("Mule Agent REST service is not available", e);
        }
        if (e.getCause() instanceof SocketTimeoutException) {
            return new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
        }
        return supplier.get();
    }

    private DeploymentException newDeploymentException(String message, Exception e) {
        ToolingAgentHandlerException toolingAgentHandlerException;
        if (e instanceof ToolingAgentHandlerException && (toolingAgentHandlerException = (ToolingAgentHandlerException)e).getErrorEntity().isPresent()) {
            ErrorEntity errorEntity = toolingAgentHandlerException.getErrorEntity().get();
            return new DeploymentException(message + ". Message: " + e.getMessage(), errorEntity.getErrorMessage(), errorEntity.getErrorType(), this.errorDetailToStringArray(errorEntity));
        }
        return new DeploymentException(e.getMessage(), e);
    }

    private ToolingException handleToolingAgentHandlerException(ToolingAgentHandlerException e) {
        Optional<ErrorEntity> errorEntityOptional = e.getErrorEntity();
        if (!errorEntityOptional.isPresent()) {
            return new ToolingException(e.getMessage(), (Throwable)e);
        }
        ErrorEntity errorEntity = errorEntityOptional.get();
        ErrorCode errorCode = errorEntityOptional.map(entity -> ErrorCode.get(entity.getErrorType())).orElse(ErrorCode.UNKNOWN_ERROR);
        if (errorCode == ErrorCode.NO_SUCH_APPLICATION) {
            return new NoSuchApplicationException("Application resource not found. Message: " + errorEntity.getErrorMessage(), (Exception)e);
        }
        if (errorCode == ErrorCode.BUNDLE_NOT_FOUND) {
            return new BundleNotFoundException("Mule Runtime could not find an artifact. Message: " + errorEntity.getErrorMessage(), (Exception)e);
        }
        if (errorCode == ErrorCode.CONNECTIVITY_TESTING_OBJECT_NOT_FOUND) {
            return new ConnectivityTestingObjectNotFoundException("Object not found. Message: " + errorEntity.getErrorMessage(), (Exception)e);
        }
        if (errorCode == ErrorCode.UNSUPPORTED_CONNECTIVITY_TESTING_OBJECT) {
            return new UnsupportedConnectivityTestingObjectException("Component doesn't support connectivity testing");
        }
        return ToolingException.builder().withMessage(e.getMessage()).withRootCauseMessage(errorEntity.getErrorMessage()).withRootCauseType(errorEntity.getErrorType()).withRootCauseStackTrace(this.errorDetailToStringArray(errorEntity)).build();
    }

    private String[] errorDetailToStringArray(ErrorEntity errorEntity) {
        return errorEntity.getErrorDetail() != null ? errorEntity.getErrorDetail().split(System.lineSeparator()) : new String[]{};
    }

    public String toString() {
        return String.format("%s{url=%s}", ClassUtils.getShortClassName(this.getClass()), this.url);
    }
}

