/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.sessions;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.sessions.SessionId;
import org.mule.tooling.api.request.session.DeclarationSessionCreationRequest;
import org.mule.tooling.api.serialization.Serializer;
import org.mule.tooling.api.serialization.SerializerFactory;
import org.slf4j.MDC;

public class DeclarationSessions {
    private String baseUrl;
    private Client client;
    private Serializer serializer;

    public DeclarationSessions(String toolingApiUrl, Client client) {
        this.baseUrl = toolingApiUrl + "/declaration-sessions";
        this.client = client;
        this.serializer = SerializerFactory.jsonSerializer();
    }

    public String post(DeclarationSessionCreationRequest declarationSessionCreationRequest, boolean verboseErrorsEnabled) {
        WebTarget target = this.client.target(this.baseUrl);
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder.header("X-B3-TraceId", (Object)MDC.get((String)"X-B3-TraceId"));
        Response response = invocationBuilder.post(Entity.entity((Object)this.serializer.serialize((Object)declarationSessionCreationRequest), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return (String)response.readEntity(String.class);
    }

    public SessionId sessionId(String sessionId) {
        return new SessionId(this.baseUrl, this.client, this.serializer, sessionId);
    }
}

