/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.sessions;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.ConnectivityTestingResponseSerializer;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;
import org.slf4j.MDC;

public class Connection {
    private static final String CONFIG_NAME_QUERY_PARAM = "configName";
    private String baseUrl;
    private Client client;

    public Connection(String baseUrl, Client client) {
        this.baseUrl = baseUrl + "/connection";
        this.client = client;
    }

    public ConnectivityTestingResponse get(String configName, boolean verboseErrorsEnabled) throws ToolingAgentHandlerException {
        WebTarget target = this.client.target(this.baseUrl);
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        target = target.queryParam(CONFIG_NAME_QUERY_PARAM, new Object[]{configName});
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder.header("X-B3-TraceId", (Object)MDC.get((String)"X-B3-TraceId"));
        Response response = invocationBuilder.get();
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return this.readConnectivityTestingResponse(response);
    }

    private ConnectivityTestingResponse readConnectivityTestingResponse(Response response) throws ToolingAgentHandlerException {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return new ConnectivityTestingResponseSerializer().deserialize((String)response.readEntity(String.class));
    }
}

