/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.applications;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.ApplicationId;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.ApplicationName;
import org.mule.tooling.agent.rest.client.tooling.applications.model.ApplicationsGETResponse;
import org.mule.tooling.agent.rest.client.tooling.applications.model.ApplicationsPUTBody;
import org.mule.tooling.agent.rest.client.tooling.applications.model.ApplicationsPUTResponse;

public class Applications {
    private static final String DOMAIN_NAME_QUERY_PARAM = "domainName";
    private static final String ARTIFACT_ID = "artifactId";
    private String baseUrl;
    private Client client;

    public Applications(String baseUrl, Client client) {
        this.baseUrl = baseUrl + "/applications";
        this.client = client;
    }

    private Client getClient() {
        return this.client;
    }

    private String getBaseUri() {
        return this.baseUrl;
    }

    public List<ApplicationsGETResponse> get(boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return (List)response.readEntity((GenericType)new GenericType<List<ApplicationsGETResponse>>(){});
    }

    public ApplicationsPUTResponse put(ApplicationsPUTBody body, boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.put(Entity.json((Object)body))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        ApplicationsPUTResponse applicationsPUTResponse = (ApplicationsPUTResponse)response.readEntity(ApplicationsPUTResponse.class);
        response.close();
        return applicationsPUTResponse;
    }

    public ApplicationsPUTResponse put(InputStream body, String artifactId, boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam(ARTIFACT_ID, new Object[]{artifactId});
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.put(Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return (ApplicationsPUTResponse)response.readEntity(ApplicationsPUTResponse.class);
    }

    public ApplicationsPUTResponse put(InputStream body, String artifactId, String domainName, boolean verboseErrorsEnabled, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam(ARTIFACT_ID, new Object[]{artifactId});
        target = target.queryParam(DOMAIN_NAME_QUERY_PARAM, new Object[]{domainName});
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.put(Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return (ApplicationsPUTResponse)response.readEntity(ApplicationsPUTResponse.class);
    }

    public final ApplicationId applicationId(String applicationId) {
        return new ApplicationId(this.getBaseUri(), this.getClient(), applicationId);
    }

    public final ApplicationName applicationName(String applicationName) {
        return new ApplicationName(this.getBaseUri(), this.getClient(), applicationName);
    }
}

