/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.valueProviders;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.extension.api.persistence.value.ValueResultJsonSerializer;
import org.mule.tooling.agent.rest.client.UriUtils;
import org.mule.tooling.agent.rest.client.exceptions.ToolingAgentHandlerException;

public class ValueProviders {
    private final String baseUri;
    private final Client client;

    public ValueProviders(String baseUri, Client client) {
        this.baseUri = baseUri + "/valueProviders";
        this.client = client;
    }

    private Client getClient() {
        return this.client;
    }

    private String getBaseUri() {
        return this.baseUri;
    }

    public ValueResult get(String valueProviderName, int readTimeout) throws ToolingAgentHandlerException {
        Response response;
        WebTarget target = this.getClient().target(UriUtils.resolveUri(this.getBaseUri(), valueProviderName));
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if ((response = invocationBuilder.get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingAgentHandlerException.newToolingAgentHandlerException(response);
        }
        return new ValueResultJsonSerializer().deserialize((String)response.readEntity(String.class));
    }
}

