/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.event.model;

import java.util.Arrays;
import java.util.Objects;
import org.mule.tooling.event.model.DataTypeModel;

public class TypedValueModel {
    private DataTypeModel dataType;
    private byte[] content;
    private boolean truncated;

    public TypedValueModel() {
    }

    private TypedValueModel(DataTypeModel dataType, byte[] content, boolean truncated) {
        Objects.requireNonNull(dataType, "dataType cannot be null");
        this.dataType = dataType;
        this.content = content;
        this.truncated = truncated;
    }

    public DataTypeModel getDataType() {
        return this.dataType;
    }

    public byte[] getContent() {
        return this.content;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedValueModel that = (TypedValueModel)o;
        if (this.truncated != that.truncated) {
            return false;
        }
        if (!this.dataType.equals(that.dataType)) {
            return false;
        }
        return Arrays.equals(this.content, that.content);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = this.dataType.hashCode();
        result = 31 * result + Arrays.hashCode(this.content);
        result = 31 * result + (this.truncated ? 1 : 0);
        return result;
    }

    public static class Builder {
        private DataTypeModel dataType;
        private byte[] content;
        private boolean truncated = false;

        private Builder() {
        }

        public Builder withDataType(DataTypeModel dataTypeModel) {
            this.dataType = dataTypeModel;
            return this;
        }

        public Builder withContent(byte[] content) {
            this.content = content;
            return this;
        }

        public Builder withTruncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public TypedValueModel build() {
            return new TypedValueModel(this.dataType, this.content, this.truncated);
        }
    }
}

