/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.event.model.component;

/**
 * A component identifier that contains the namespace, name and type.
 *
 * @since 1.0
 */
public class TypedComponentIdentifier {

  private String type;
  private String namespace;
  private String name;

  // Used by json serializer/deserialzer
  public TypedComponentIdentifier() {}

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getNamespace() {
    return namespace;
  }

  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public static class TypedComponentIdentifierBuilder {

    private TypedComponentIdentifier typedComponentIdentifier;

    public TypedComponentIdentifierBuilder() {
      this.typedComponentIdentifier = new TypedComponentIdentifier();
    }

    public TypedComponentIdentifierBuilder withType(String type) {
      this.typedComponentIdentifier.setType(type);
      return this;
    }

    public TypedComponentIdentifierBuilder withNamespace(String namespace) {
      this.typedComponentIdentifier.setNamespace(namespace);
      return this;
    }

    public TypedComponentIdentifierBuilder withName(String name) {
      this.typedComponentIdentifier.setName(name);
      return this;
    }

    public TypedComponentIdentifier build() {
      return this.typedComponentIdentifier;
    }

  }

}
