/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.event.model;

public class MessageModel {

  private TypedValueModel attributes;
  private TypedValueModel payload;

  // Used by json serializer/deserialzer
  public MessageModel() {}

  private MessageModel(TypedValueModel attributes, TypedValueModel payload) {
    this.attributes = attributes;
    this.payload = payload;
  }

  public TypedValueModel getAttributes() {
    return attributes;
  }

  public TypedValueModel getPayload() {
    return payload;
  }

  public static Builder builder() {
    return new Builder();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    MessageModel that = (MessageModel) o;

    if (attributes != null ? !attributes.equals(that.attributes) : that.attributes != null) {
      return false;
    }
    return payload != null ? payload.equals(that.payload) : that.payload == null;
  }

  @Override
  public int hashCode() {
    int result = attributes != null ? attributes.hashCode() : 0;
    result = 31 * result + (payload != null ? payload.hashCode() : 0);
    return result;
  }

  public static class Builder {

    private TypedValueModel attributes;
    private TypedValueModel payload;

    private Builder() {}

    public Builder withAttributes(TypedValueModel attributes) {
      this.attributes = attributes;
      return this;
    }

    public Builder withPayload(TypedValueModel payload) {
      this.payload = payload;
      return this;
    }

    public MessageModel build() {
      return new MessageModel(this.attributes, this.payload);
    }

  }

}
