/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.event.model;

import org.mule.tooling.event.model.MessageModel;

public class ErrorModel {
    private String description;
    private String detailedDescription;
    private String type;
    private String exceptionType;
    private MessageModel message;

    public ErrorModel() {
    }

    private ErrorModel(String description, String detailedDescription, String type, MessageModel message, String exceptionType) {
        this.description = description;
        this.detailedDescription = detailedDescription;
        this.type = type;
        this.message = message;
        this.exceptionType = exceptionType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetailedDescription() {
        return this.detailedDescription;
    }

    public String getType() {
        return this.type;
    }

    public MessageModel getMessage() {
        return this.message;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorModel that = (ErrorModel)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.detailedDescription != null ? !this.detailedDescription.equals(that.detailedDescription) : that.detailedDescription != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.exceptionType != null ? !this.exceptionType.equals(that.exceptionType) : that.exceptionType != null) {
            return false;
        }
        return this.message != null ? this.message.equals(that.message) : that.message == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.detailedDescription != null ? this.detailedDescription.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.exceptionType != null ? this.exceptionType.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String description;
        private String detailedDescription;
        private String type;
        private String exceptionType;
        private MessageModel message;

        private Builder() {
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withDetailedDescription(String detailedDescription) {
            this.detailedDescription = detailedDescription;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withMessage(MessageModel message) {
            this.message = message;
            return this;
        }

        public Builder withExceptionType(String exceptionType) {
            this.exceptionType = exceptionType;
            return this;
        }

        public ErrorModel build() {
            return new ErrorModel(this.description, this.detailedDescription, this.type, this.message, this.exceptionType);
        }
    }
}

