/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.event.model.component.location;

import org.mule.tooling.event.model.component.TypedComponentIdentifier;

import java.util.List;

/**
 * Representation of the component in a Mule Configuration.
 *
 * @since 1.0
 */
public class ComponentLocation {

  private String location;
  private String fileName;
  private Integer lineInFile;
  private List<LocationPart> parts;
  private TypedComponentIdentifier typedComponentIdentifier;

  // Used by json serializer/deserialzer
  public ComponentLocation() {}

  public String getLocation() {
    return location;
  }

  public void setLocation(String location) {
    this.location = location;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public Integer getLineInFile() {
    return lineInFile;
  }

  public void setLineInFile(Integer lineInFile) {
    this.lineInFile = lineInFile;
  }

  public TypedComponentIdentifier getTypedComponentIdentifier() {
    return typedComponentIdentifier;
  }

  public void setTypedComponentIdentifier(TypedComponentIdentifier typedComponentIdentifier) {
    this.typedComponentIdentifier = typedComponentIdentifier;
  }

  public List<LocationPart> getParts() {
    return parts;
  }

  public void setParts(List<LocationPart> parts) {
    this.parts = parts;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ComponentLocation that = (ComponentLocation) o;

    if (!location.equals(that.location)) {
      return false;
    }
    if (fileName != null ? !fileName.equals(that.fileName) : that.fileName != null) {
      return false;
    }
    if (lineInFile != null ? !lineInFile.equals(that.lineInFile) : that.lineInFile != null) {
      return false;
    }
    if (parts != null ? !parts.equals(that.parts) : that.parts != null) {
      return false;
    }
    if (typedComponentIdentifier != null ? !typedComponentIdentifier.equals(that.typedComponentIdentifier)
        : this.typedComponentIdentifier != null) {
      return false;
    }
    return true;
  }

  @Override
  public int hashCode() {
    int result = location.hashCode();
    result = 31 * result + (fileName != null ? fileName.hashCode() : 0);
    result = 31 * result + (lineInFile != null ? lineInFile.hashCode() : 0);
    result = 31 * result + (parts != null ? parts.hashCode() : 0);
    result = 31 * result + (typedComponentIdentifier != null ? typedComponentIdentifier.hashCode() : 0);
    return result;
  }

  public static class ComponentLocationBuilder {

    private ComponentLocation componentLocation;

    public ComponentLocationBuilder() {
      this.componentLocation = new ComponentLocation();
    }

    public ComponentLocationBuilder withLocation(String location) {
      this.componentLocation.setLocation(location);
      return this;
    }

    public ComponentLocationBuilder withFileName(String fileName) {
      this.componentLocation.setFileName(fileName);
      return this;
    }

    public ComponentLocationBuilder withLineInFile(Integer lineInFile) {
      this.componentLocation.setLineInFile(lineInFile);
      return this;
    }

    public ComponentLocationBuilder withParts(List<LocationPart> parts) {
      this.componentLocation.setParts(parts);
      return this;
    }

    public ComponentLocationBuilder withTypedComponentIdentifier(TypedComponentIdentifier typedComponentIdentifier) {
      this.componentLocation.setTypedComponentIdentifier(typedComponentIdentifier);
      return this;
    }

    public ComponentLocation build() {
      return this.componentLocation;
    }

  }

}
