/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.event.model;

import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

public class DataTypeModelTest {

  private DataTypeModel dataTypeModel;
  private DataTypeModel.Builder builder;

  @Before
  public void setUp() {
    builder = DataTypeModel.builder()
        .withType("application/json")
        .withMediaType("application/json");
    dataTypeModel = builder.build();
  }

  @Test
  public void testGetType() {
    assertEquals("application/json", dataTypeModel.getType());
  }

  @Test
  public void testGetMediaType() {
    assertEquals("application/json", dataTypeModel.getMediaType());
  }

  @Test
  public void testGetModelType() {
    assertNotNull(dataTypeModel.getModelType());
  }

  @Test
  public void testEqualsAndHashCode() {
    DataTypeModel anotherDataTypeModel = builder.build();
    assertEquals(dataTypeModel, anotherDataTypeModel);
    assertEquals(dataTypeModel.hashCode(), anotherDataTypeModel.hashCode());
  }

  @Test
  public void testBuilderAsCollectionWithItemsType() {
    DataTypeModel collectionDataTypeModel = DataTypeModel.builder()
        .withType("application/json")
        .withMediaType("application/json")
        .asCollectionWithItemsType("itemType")
        .build();

    assertNotNull(collectionDataTypeModel.getModelType());
    assertFalse(dataTypeModel.equals(collectionDataTypeModel));
  }
}
