/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.event.model;

import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

public class ErrorModelTest {

  private ErrorModel errorModel;
  private MessageModel messageModel;

  @Before
  public void setUp() {
    messageModel = new MessageModel(); // Assuming a default constructor exists
    errorModel = ErrorModel.builder()
        .withDescription("Error description")
        .withDetailedDescription("Detailed error description")
        .withType("ErrorType")
        .withMessage(messageModel)
        .withExceptionType("ExceptionType")
        .build();
  }

  @Test
  public void testGetDescription() {
    assertEquals("Error description", errorModel.getDescription());
  }

  @Test
  public void testGetDetailedDescription() {
    assertEquals("Detailed error description", errorModel.getDetailedDescription());
  }

  @Test
  public void testGetType() {
    assertEquals("ErrorType", errorModel.getType());
  }

  @Test
  public void testGetMessage() {
    assertEquals(messageModel, errorModel.getMessage());
  }

  @Test
  public void testGetExceptionType() {
    assertEquals("ExceptionType", errorModel.getExceptionType());
  }

  @Test
  public void testEqualsAndHashCode() {
    assertFalse(errorModel.equals(null));
    assertTrue(errorModel.equals(errorModel));
    ErrorModel sameErrorModel = ErrorModel.builder()
        .withDescription("Error description")
        .withDetailedDescription("Detailed error description")
        .withType("ErrorType")
        .withMessage(messageModel)
        .withExceptionType("ExceptionType")
        .build();

    assertEquals(errorModel, sameErrorModel);
    assertEquals(errorModel.hashCode(), sameErrorModel.hashCode());

    // Different description
    ErrorModel differentDescriptionModel = ErrorModel.builder()
        .withDescription("Different description")
        .withDetailedDescription("Detailed error description")
        .withType("ErrorType")
        .withMessage(messageModel)
        .withExceptionType("ExceptionType")
        .build();
    assertFalse(errorModel.equals(differentDescriptionModel));
    ErrorModel differentDescriptionModel1 = ErrorModel.builder()
        .withDescription("Error description")
        .withDetailedDescription("Detailed error description1")
        .withType("w")
        .withMessage(messageModel)
        .withExceptionType("ExceptionType")
        .build();
    assertFalse(errorModel.equals(differentDescriptionModel1));
  }

  @Test
  public void testBuilderWithNullValues() {
    ErrorModel nullValuesModel = ErrorModel.builder()
        .withDescription(null)
        .withDetailedDescription(null)
        .withType(null)
        .withMessage(null)
        .withExceptionType(null)
        .build();

    assertNull(nullValuesModel.getDescription());
    assertNull(nullValuesModel.getDetailedDescription());
    assertNull(nullValuesModel.getType());
    assertNull(nullValuesModel.getMessage());
    assertNull(nullValuesModel.getExceptionType());
  }
}
