/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.event.model;

import org.junit.Test;
import static org.junit.Assert.*;

public class ModelTypeTest {

  @Test
  public void testConstructor() {
    ModelType modelType = new ModelType(true, "application/json");
    assertTrue(modelType.isCollection());
    assertEquals("application/json", modelType.getItemsType());
  }

  @Test
  public void testCollectionModelType() {
    ModelType collectionModelType = ModelType.collectionModelType("application/xml");
    assertTrue(collectionModelType.isCollection());
    assertEquals("application/xml", collectionModelType.getItemsType());
  }

  @Test
  public void testSimpleModelType() {
    ModelType simpleModelType = ModelType.simpleModelType();
    assertFalse(simpleModelType.isCollection());
    assertNull(simpleModelType.getItemsType());
  }

  @Test
  public void testEquals() {
    ModelType modelType1 = new ModelType(true, "application/json");
    ModelType modelType2 = new ModelType(true, "application/json");
    ModelType modelType3 = new ModelType(false, "application/json");
    ModelType modelType4 = new ModelType(true, "application/xml");

    assertEquals(modelType1, modelType2);
    assertFalse(modelType1.equals(modelType3));
    assertFalse(modelType1.equals(modelType4));
  }

  @Test
  public void testEqualsWithNull() {
    ModelType modelType = new ModelType(true, "application/json");
    assertFalse(modelType.equals(null));
  }

  @Test
  public void testEqualsWithDifferentClass() {
    ModelType modelType = new ModelType(true, "application/json");
    assertFalse(modelType.equals("Some String"));
  }
}
