/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.event.model;

import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;
import java.util.Arrays;

public class TypedValueModelTest {

  private TypedValueModel typedValueModel;
  private DataTypeModel dataType;
  private byte[] content;

  @Before
  public void setUp() {
    dataType = new DataTypeModel(); // Assuming a default constructor exists
    content = new byte[] {1, 2, 3};

    typedValueModel = TypedValueModel.builder()
        .withDataType(dataType)
        .withContent(content)
        .withTruncated(false)
        .withError(false)
        .withExceptionMessage(null)
        .withExceptionStackTrace(null)
        .build();
  }

  @Test
  public void testGetDataType() {
    assertEquals(dataType, typedValueModel.getDataType());
  }

  @Test
  public void testGetContent() {
    assertTrue(Arrays.equals(content, typedValueModel.getContent()));
  }

  @Test
  public void testIsTruncated() {
    assertFalse(typedValueModel.isTruncated());
  }

  @Test
  public void testIsError() {
    assertFalse(typedValueModel.isError());
  }

  @Test
  public void testGetExceptionMessage() {
    assertNull(typedValueModel.getExceptionMessage());
  }

  @Test
  public void testGetExceptionStackTrace() {
    assertNull(typedValueModel.getExceptionStacktrace());
  }

  @Test
  public void testEqualsAndHashCode() {
    assertFalse(typedValueModel.equals(null));
    assertTrue(typedValueModel.equals(typedValueModel));
    TypedValueModel sameTypedValueModel = TypedValueModel.builder()
        .withDataType(dataType)
        .withContent(content)
        .withTruncated(false)
        .withError(false)
        .withExceptionMessage(null)
        .withExceptionStackTrace(null)
        .build();

    assertEquals(typedValueModel, sameTypedValueModel);
    assertEquals(typedValueModel.hashCode(), sameTypedValueModel.hashCode());

    // Different content
    TypedValueModel differentContentModel = TypedValueModel.builder()
        .withDataType(dataType)
        .withContent(new byte[] {4, 5, 6})
        .withTruncated(false)
        .withError(false)
        .withExceptionMessage(null)
        .withExceptionStackTrace(null)
        .build();
    assertFalse(typedValueModel.equals(differentContentModel));
  }

  @Test
  public void testBuilderWithNullValues() {
    TypedValueModel nullValuesModel = TypedValueModel.builder()
        .withDataType(dataType)
        .withContent(null)
        .withTruncated(false)
        .withError(false)
        .withExceptionMessage(null)
        .withExceptionStackTrace(null)
        .build();

    assertNull(nullValuesModel.getContent());
  }
}
