/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.event.model.component;

import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

public class TypedComponentIdentifierTest {

  private TypedComponentIdentifier identifier;

  @Before
  public void setUp() {
    identifier = new TypedComponentIdentifier();
    identifier.setType("componentType");
    identifier.setNamespace("componentNamespace");
    identifier.setName("componentName");
  }

  @Test
  public void testGetType() {
    assertEquals("componentType", identifier.getType());
  }

  @Test
  public void testGetNamespace() {
    assertEquals("componentNamespace", identifier.getNamespace());
  }

  @Test
  public void testGetName() {
    assertEquals("componentName", identifier.getName());
  }

  @Test
  public void testEqualsAndHashCode() {
    TypedComponentIdentifier anotherIdentifier = new TypedComponentIdentifier();
    anotherIdentifier.setType("componentType");
    anotherIdentifier.setNamespace("componentNamespace");
    anotherIdentifier.setName("componentName");

    assertEquals(identifier, anotherIdentifier);
    assertEquals(identifier.hashCode(), anotherIdentifier.hashCode());
  }

  @Test
  public void testTypedComponentIdentifierBuilder() {
    TypedComponentIdentifier builtIdentifier = new TypedComponentIdentifier.TypedComponentIdentifierBuilder()
        .withType("componentType")
        .withNamespace("componentNamespace")
        .withName("componentName")
        .build();

    assertEquals(identifier, builtIdentifier);
  }
}
