/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.event.model.component.location;

import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;
import org.mule.tooling.event.model.component.TypedComponentIdentifier;

public class LocationPartTest {

  private LocationPart locationPart;
  private TypedComponentIdentifier typedComponentIdentifier;

  @Before
  public void setUp() {
    typedComponentIdentifier = new TypedComponentIdentifier(); // Assuming a default constructor exists
    locationPart = new LocationPart.LocationPartBuilder()
        .withPartPath("/path/to/part")
        .withFileName("fileName.xml")
        .withLineInFile(42)
        .withTypedComponentIdentifier(typedComponentIdentifier)
        .build();
  }

  @Test
  public void testGetPartPath() {
    assertEquals("/path/to/part", locationPart.getPartPath());
  }

  @Test
  public void testGetFileName() {
    assertEquals("fileName.xml", locationPart.getFileName());
  }

  @Test
  public void testGetLineInFile() {
    assertEquals(Integer.valueOf(42), locationPart.getLineInFile());
  }

  @Test
  public void testGetTypedComponentIdentifier() {
    assertEquals(typedComponentIdentifier, locationPart.getTypedComponentIdentifier());
  }

  @Test
  public void testEqualsAndHashCode() {
    LocationPart sameLocationPart = new LocationPart.LocationPartBuilder()
        .withPartPath("/path/to/part")
        .withFileName("fileName.xml")
        .withLineInFile(42)
        .withTypedComponentIdentifier(typedComponentIdentifier)
        .build();

    assertEquals(locationPart, sameLocationPart);
    assertEquals(locationPart.hashCode(), sameLocationPart.hashCode());
    assertEquals(locationPart, locationPart);
    assertFalse(locationPart.equals(null));

    // Different part path
    LocationPart differentPartPath = new LocationPart.LocationPartBuilder()
        .withPartPath("/different/path")
        .withFileName("fileName.xml")
        .withLineInFile(42)
        .withTypedComponentIdentifier(typedComponentIdentifier)
        .build();
    assertFalse(locationPart.equals(differentPartPath));
  }

  @Test
  public void testBuilderWithNullValues() {
    LocationPart nullValuesPart = new LocationPart.LocationPartBuilder()
        .withPartPath(null)
        .withFileName(null)
        .withLineInFile(null)
        .withTypedComponentIdentifier(null)
        .build();

    assertNull(nullValuesPart.getPartPath());
    assertNull(nullValuesPart.getFileName());
    assertNull(nullValuesPart.getLineInFile());
    assertNull(nullValuesPart.getTypedComponentIdentifier());
  }
}
