/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.event.model;

/**
 * Represents the Model Type of a Data Type. This can also be a collection of some media type.
 *
 * @deprecated 1.1 as TypedValue at root level are serialized (case of TypedValue that represents a Message,
 * Collection of Messages, POJOs, and other similar cases are just serialized from the root element).
 * 
 * @since 1.0
 */
@Deprecated
public class ModelType {

  private String itemsType;
  private boolean collection;

  // Used by json serializer/deserializer
  public ModelType() {}

  public ModelType(boolean collection, String itemsType) {
    this.itemsType = itemsType;
    this.collection = collection;
  }

  /**
   * @param itemsType the media type as String for each item in the collection
   * @return a new Model type representing a collection model type
   */
  public static ModelType collectionModelType(String itemsType) {
    return new ModelType(true, itemsType);
  }

  /**
   * @return a single {@ling ModelType} with null item type
   */
  public static ModelType simpleModelType() {
    return new ModelType(false, null);
  }

  /**
   * @return whether the {@link ModelType} represents a collection or not.
   */
  public boolean isCollection() {
    return this.collection;
  }

  /**
   * @return the String representation of the ModelType. If the ModelType is not  collection
   * (i.e. {@link ModelType#isCollection()} is false) then this value represents the type for
   * each element in the collection.
   */
  public String getItemsType() {
    return this.itemsType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ModelType that = (ModelType) o;
    if (this.collection != that.collection) {
      return false;
    }

    return this.itemsType.equals(that.itemsType);
  }
}
