/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.event.model.component;

/**
 * A component identifier that contains the namespace, name and type.
 *
 * @since 1.0
 */
public class TypedComponentIdentifier {

  private String type;
  private String namespace;
  private String name;

  // Used by json serializer/deserialzer
  public TypedComponentIdentifier() {}

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getNamespace() {
    return namespace;
  }

  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    TypedComponentIdentifier that = (TypedComponentIdentifier) o;

    if (!type.equals(that.type)) {
      return false;
    }
    if (!namespace.equals(that.namespace)) {
      return false;
    }
    return name.equals(that.name);
  }

  @Override
  public int hashCode() {
    int result = type.hashCode();
    result = 31 * result + namespace.hashCode();
    result = 31 * result + name.hashCode();
    return result;
  }

  public static class TypedComponentIdentifierBuilder {

    private TypedComponentIdentifier typedComponentIdentifier;

    public TypedComponentIdentifierBuilder() {
      this.typedComponentIdentifier = new TypedComponentIdentifier();
    }

    public TypedComponentIdentifierBuilder withType(String type) {
      this.typedComponentIdentifier.setType(type);
      return this;
    }

    public TypedComponentIdentifierBuilder withNamespace(String namespace) {
      this.typedComponentIdentifier.setNamespace(namespace);
      return this;
    }

    public TypedComponentIdentifierBuilder withName(String name) {
      this.typedComponentIdentifier.setName(name);
      return this;
    }

    public TypedComponentIdentifier build() {
      return this.typedComponentIdentifier;
    }

  }

}
