/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.runtime.process.controller;

import static java.lang.Integer.parseInt;

import java.io.File;
import java.util.List;

import org.zeroturnaround.exec.ProcessExecutor;

/**
 * Windows specific process controller for Mule Runtime.
 *
 * @since 4.0
 */
class WindowsMuleProcessController extends AbstractMuleProcessController {

  private static final String MULE_BAT = "mule.bat";
  public static final String WRAPPER_WINDOWS = "wrapper-windows*";

  /**
   * Creates an instance of a Windows controller for Mule Runtime.
   *
   * @param muleHome     {@link File} location of the local Mule Runtime {@code MULE_HOME}
   * @param timeout      milliseconds to wait for Mule Runtime operations to be completed.
   */
  WindowsMuleProcessController(File muleHome, long timeout) {
    super(muleHome, timeout, MULE_BAT);
  }

  @Override
  protected int getPID() throws Exception {
    final String taskListCommand = String.format("tasklist /fi \"imagename eq %s\" /fo csv", WRAPPER_WINDOWS);
    List<String> lines = new ProcessExecutor()
        .commandSplit(taskListCommand)
        .readOutput(true).execute().getOutput().getLines();
    if (lines.size() == 1) {
      // No PID found
      return -1;
    }
    // CSV has the result of the PID, second column is PID
    return parseInt((lines.get(1).split(",")[1].replaceAll("^\"|\"$", "")));
  }

}
