/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.runtime.process.controller.command;

import org.mule.tooling.runtime.process.controller.MuleServiceWrapper;

import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessOutput;
import org.zeroturnaround.exec.ProcessResult;

/**
 * Status command, available for Unix environments only.
 * <p>
 * Checks the status of Mule Runtime, keeps the exit value so it is accessible from {@link #getExitValue()}.
 *
 * @since 4.0
 */
public class StatusMuleCommand extends AbstractMuleCommand {

  private Integer exitValue;
  private ProcessOutput processOutput;

  /**
   * Creates an instance of the command.
   *
   * @param muleServiceWrapper {@link MuleServiceWrapper} to execute the command. Non null.
   */
  public StatusMuleCommand(MuleServiceWrapper muleServiceWrapper) {
    super(muleServiceWrapper);
  }

  @Override
  protected void doExecute() throws Exception {
    ProcessExecutor processExecutor = createMuleProcessExecutor("status");
    processExecutor.readOutput(true);
    ProcessResult processResult = processExecutor.execute();
    this.exitValue = processResult.getExitValue();
    this.processOutput = processResult.getOutput();
  }

  /**
   * @return {@code int} with the exit value for the status command.
   */
  public int getExitValue() {
    checkState(exitValue != null, "Status command was not executed");
    return exitValue;
  }

  /**
   * @return {@link ProcessOutput} of the status command.
   */
  public ProcessOutput getProcessOutput() {
    checkState(processOutput != null, "Status command was not executed");
    return processOutput;
  }

}
