/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.runtime.process.controller.command;

import static java.util.Arrays.asList;
import org.mule.tooling.runtime.process.controller.MuleServiceWrapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;

/**
 * Command to start Mule Runtime in console mode.
 *
 * @since 4.0
 */
public class ConsoleMuleCommand extends AbstractMuleCommand {

  public static final String WWRAPPER_CONSOLE_FLUSH_TRUE = "-Wwrapper.console.flush=true";
  private String[] args;
  private StartedProcess process;

  /**
   * Creates an instance of the command.
   *
   * @param muleServiceWrapper {@link MuleServiceWrapper} to execute the command. Non null.
   * @param args               array of {@link String} arguments to be passed when Mule Runtime is started.
   */
  public ConsoleMuleCommand(MuleServiceWrapper muleServiceWrapper, String... args) {
    super(muleServiceWrapper);
    this.args = args;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doExecute() throws InterruptedException, TimeoutException, IOException {
    List<String> arguments = new ArrayList<>();
    arguments.addAll(asList(args));
    arguments.add(WWRAPPER_CONSOLE_FLUSH_TRUE);
    if (logger.isDebugEnabled()) {
      logger.debug("Starting Mule Runtime in console mode, arguments: {}", arguments);
    }
    final ProcessExecutor processExecutor = createMuleProcessExecutor(arguments);
    process = processExecutor.start();
  }

  /**
   * @return {@link StartedProcess} for the console command.
   */
  public StartedProcess getProcess() {
    return this.process;
  }
}
