/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.runtime.process.controller;

import static org.apache.commons.lang.SystemUtils.IS_OS_WINDOWS;

import java.io.File;

/**
 * Factory for {@link MuleProcessController}. Based on the OS it will create the corresponding controller.
 *
 * @since 4.0
 */
public class MuleProcessControllerFactory {

  /**
   * Creates a {@link MuleProcessController} based on the OS.
   *
   * @param muleHome {@link File} location of the local Mule Runtime {@code MULE_HOME}
   * @param timeout  milliseconds to wait for Mule Runtime operations to be completed.
   * @return {@link MuleProcessController} created
   */
  public static MuleProcessController createController(File muleHome, long timeout) {
    return IS_OS_WINDOWS ? new WindowsMuleProcessController(muleHome, timeout)
        : new UnixMuleProcessController(muleHome, timeout);
  }

}
