/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.dsl;

import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.artifact.dsl.request.DslSyntaxResolverFactoryRequest;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.model.ExtensionModel;

/**
 * Service for obtaining the {@link DslSyntaxResolverFactory} that will allow the user to create
 * the {@link DslElementSyntax} data for any given component of an {@link ExtensionModel}
 *
 * @since 1.0
 */
public interface DslSyntaxResolverService extends Disposable {

  /**
   * Creates a new {@link DslSyntaxResolverFactory} for the given plugins context.
   *
   * @param request the {@link DslSyntaxResolverFactoryRequest} that contains the {@link ArtifactDescriptor plugin descriptors}
   *                that compose the DSL resolution context.
   * @return an {@link DslSyntaxResolverFactory} for the given plugins context
   */
  DslSyntaxResolverFactory getDslSyntaxResolverFactory(DslSyntaxResolverFactoryRequest request);

}
