/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.runtime.api.component.location.Location;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.request.AbstractToolingRequest;

/**
 * Request for {@link DataSenseService}.
 *
 * @since 1.0
 */
public class DataSenseRequest extends AbstractToolingRequest {

  private Location location;
  private DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider;

  /**
   * Sets the location from the {@link ToolingArtifact} configuration to be used for resolving DataSense.
   *
   * @param location from the {@link ToolingArtifact} configuration.
   */
  public void setLocation(Location location) {
    requireNonNull(location, "location cannot null");
    this.location = location;
  }

  /**
   * @return the componentPath from the {@link ToolingArtifact} configuration.
   */
  public Location getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return format("%s{requestTimeout=%s,location=%s}", getShortClassName(this.getClass()),
                  getRequestTimeout(),
                  getLocation());
  }

  /**
   * @return the {@link DataSenseMetadataCacheProvider}.
   */
  public DataSenseMetadataCacheProvider getDataSenseMetadataCacheProvider() {
    return dataSenseMetadataCacheProvider;
  }

  /**
   * Sets the {@link DataSenseMetadataCacheProvider}.
   *
   * @param dataSenseMetadataCacheProvider a {@link DataSenseMetadataCacheProvider}
   */
  public void setDataSenseMetadataCacheProvider(
                                                DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider) {
    this.dataSenseMetadataCacheProvider = dataSenseMetadataCacheProvider;
  }
}
