/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.el;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Represents the severity of a {@link ValidationMessage}
 *
 * @since 1.0
 */
public class Severity extends UnknownType {

  private boolean info = false;
  private boolean warning = false;
  private boolean error = false;

  // Just needed in order to serialize this object
  private Severity() {}

  public Severity(String value) {
    super(value);
  }

  public static Severity infoSeverity(String value) {
    Severity severity = new Severity(value);
    severity.info = true;
    return severity;
  }

  public static Severity warningSeverity(String value) {
    Severity severity = new Severity(value);
    severity.warning = true;
    return severity;
  }

  public static Severity errorSeverity(String value) {
    Severity severity = new Severity(value);
    severity.error = true;
    return severity;
  }

  public boolean isError() {
    return error;
  }

  public boolean isInfo() {
    return info;
  }

  public boolean isWarning() {
    return warning;
  }
}
