/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.construct;



import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

import java.util.List;

/**
 * Immutable concrete implementation of {@link ConstructModel}
 *
 * @since 1.0
 */
public class ConstructModel {

  private String name;
  private String description;
  private List<ParameterGroupModel> parameterGroupModels;
  private DisplayModel displayModel;
  private StereotypeModel stereotype;
  private List<? extends NestableElementModel> nestedComponents;
  private boolean allowsTopLevelDefinition;

  public ConstructModel() {}

  /**
   * Creates a new instance with the given state
   *
   * @param name                 the operation's name. Cannot be blank
   * @param description          the operation's descriptor
   * @param parameterGroupModels a {@link List} with the operation's {@link ParameterGroupModel parameter group models}
   * @param displayModel         a model which contains directive about how this operation is displayed in the UI
   * @param stereotype           the construct {@link StereotypeModel}
   * @param nestedComponents     a {@link List} with the components contained by this model
   * @param allowsTopLevelDefinition  whether or not {@code this} model can be declared as a root component in the application
   * @throws IllegalArgumentException if {@code name} is blank or {@code executorFactory} is {@code null}
   */
  public ConstructModel(String name,
                        String description,
                        List<ParameterGroupModel> parameterGroupModels,
                        DisplayModel displayModel,
                        StereotypeModel stereotype,
                        List<? extends NestableElementModel> nestedComponents,
                        boolean allowsTopLevelDefinition) {
    this.name = name;
    this.description = description;
    this.parameterGroupModels = parameterGroupModels;
    this.displayModel = displayModel;
    this.stereotype = stereotype;
    this.nestedComponents = nestedComponents;
    this.allowsTopLevelDefinition = allowsTopLevelDefinition;
  }

  public boolean allowsTopLevelDeclaration() {
    return allowsTopLevelDefinition;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public List<ParameterGroupModel> getParameterGroupModels() {
    return parameterGroupModels;
  }

  public DisplayModel getDisplayModel() {
    return displayModel;
  }

  public StereotypeModel getStereotype() {
    return stereotype;
  }

  public List<? extends NestableElementModel> getNestedComponents() {
    return nestedComponents;
  }

  public boolean isAllowsTopLevelDefinition() {
    return allowsTopLevelDefinition;
  }
}
