/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.location;

import org.mule.tooling.client.api.datasense.ComponentIdentifier;

/**
 * Descriptor for a component in the configuration along with it's {@link ComponentType}.
 *
 * @since 1.0
 */
public class TypedComponentIdentifier {

  private ComponentType componentType;
  private ComponentIdentifier identifier;

  private TypedComponentIdentifier() {}

  public TypedComponentIdentifier(ComponentIdentifier identifier, ComponentType type) {
    this.componentType = type;
    this.identifier = identifier;
  }

  /**
   * @return the type that represents the kind of the identified component.
   */
  public ComponentType getType() {
    return componentType;
  }

  /**
   * @return the component identifier
   */
  public ComponentIdentifier getIdentifier() {
    return identifier;
  }

}
